<?php

/*
Profile Buddies Plugin for MyBB
Copyright (C) 2010 Sebastian Wunderlich

This program is free software: you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation, either version 3 of the License, or
(at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program. If not, see <http://www.gnu.org/licenses/>.
*/

if(!defined('IN_MYBB'))
{
	die();
}

$plugins->add_hook('member_profile_end','profilebuddies');
$plugins->add_hook('usercp_do_editlists_end','profilebuddies_message');

function profilebuddies_info()
{
	return array
	(
		'name'=>'هاك قائمة الاصدقاء للأعضاء',
		'description'=>'اظهار قائمة في الملف الشخصي للاصدقاء.',
		'website'=>'http://mods.mybboard.net/view/profile-buddies',
		'author'=>'Sebastian Wunderlich',
		'version'=>'1.4.1',
		'guid'=>'1d7ed75d036a35f3d1f658f89dbca19f',
		'compatibility'=>'14*,16*',
		'codename'=>'profilebuddies'
	);
}

function profilebuddies_activate()
{
	global $db;
	$info=profilebuddies_info();
	$setting_group_array=array
	(
		'name'=>$info['codename'],
		'title'=>$info['name'],
		'description'=>'هنا تستطيع تعديل '.$info['name'].' اعدادات.',
		'disporder'=>1,
		'isdefault'=>0
	);
	$db->insert_query('settinggroups',$setting_group_array);
	$group=$db->insert_id();
	$settings=array
	(
		'profilebuddies_limit'=>array
		(
			'عدد الاصدقاء',
			'الجد الاقصي لعدد الاصدقاء في القائمة.',
			'text',
			10
		),
		'profilebuddies_limit_overwrite'=>array
		(
			'ظهور كل الاصدقاء',
			'هل تريد ان تعطي صلاحية للعضو بعرض كل الاصدقاء وبعيدا عن الحد الاقصي لعدد الاصدقاء',
			'yesno',
			0
		),
		'profilebuddies_order_by'=>array
		(
			'طريقة العرض',
			'اختار طريقة العرض للاصدقاء في القائمة.',
			'select
username=اسم العضو
regdate=تاريخ التسجيل
lastvisit=اخر زيارة
postnum=عدد المشاركات
RAND()=عشوائي',
			'username'
		),
		'profilebuddies_order_dir'=>array
		(
			'طريقة الترتيب',
			'اختار طريقة لترتيب الاعضاء.',
			'select
ASC=تصاعدي
DESC=تنازلي',
			'ASC'
		),
		'profilebuddies_quicklinks'=>array
		(
			'ظهور الروابط السريعة ؟',
			'هل تريد ظهور الروابط السريعه اصف او احذف اصدقاء',
			'yesno',
			0
		),
		'profilebuddies_email'=>array
		(
			'التبليغ بالبريد',
			'لو قمت بتفعيل هذا سيقوم بارسال رساله علي البريد في حالة اضافة اجد الاصدقاء له.',
			'onoff',
			0
		),
		'profilebuddies_pm'=>array
		(
			'التبليغ بالرسائل',
			'لو قمت بتفعيل هذا سيقوم بارسال رسالة في المنتدي في حالة اضافة الاصدقاء له.',
			'onoff',
			0
		)
	);
	$i=1;
	foreach($settings as $name=>$sinfo){
		$insert_array=array
		(
			'name'=>$name,
			'title'=>$db->escape_string($sinfo[0]),
			'description'=>$db->escape_string($sinfo[1]),
			'optionscode'=>$db->escape_string($sinfo[2]),
			'value'=>$db->escape_string($sinfo[3]),
			'gid'=>$group,
			'disporder'=>$i,
			'isdefault'=>0
		);
		$db->insert_query('settings',$insert_array);
		$i++;
	}
	rebuild_settings();
	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets('member_profile','#<br />{\$buddylist}#i','',0);
	find_replace_templatesets('member_profile','#{\$buddylist}#i','',0);
	find_replace_templatesets('member_profile','#{\$modoptions}#i','<br />{$buddylist}{$modoptions}');
}

function profilebuddies_deactivate()
{
	global $db;
	$info=profilebuddies_info();
	$result=$db->simple_select('settinggroups','gid','name="'.$info['codename'].'"',array('limit'=>1));
	$group=$db->fetch_array($result);
	if(!empty($group['gid']))
	{
		$db->delete_query('settinggroups','gid="'.$group['gid'].'"');
		$db->delete_query('settings','gid="'.$group['gid'].'"');
		rebuild_settings();
	}
	require_once MYBB_ROOT.'/inc/adminfunctions_templates.php';
	find_replace_templatesets('member_profile','#<br />{\$buddylist}#i','',0);
	find_replace_templatesets('member_profile','#{\$buddylist}#i','',0);
}

function profilebuddies_lang()
{
	global $lang;
	$lang->load('profilebuddies',false,true);
	$l['profilebuddies_title']='قائمة اصدقاء  {1}';
	$l['profilebuddies_title_all']='شاهد كل {1} اصدقاء';
	$l['profilebuddies_no_buddies']='{1} لا يوجد اصدقاء ل.';
	$l['profilebuddies_add_buddy']='اضف {1} في قائمة اصدقائك!';
	$l['profilebuddies_remove_buddy']='احذف {1} من قائمةاصدقائك!';
	$l['profilebuddies_email_subject']='احد الاشخاص قم باضافتك الي قائمة اصدقائه {1}';
	$l['profilebuddies_email_message']='{1},

{2} من {3} تمت اضافتك الي قائمة الاصدقاء. للمشاهدة {2}\'s الملف الشخصي, تستطيتع من هذا الرابط:

{4}/{5}

شكرا,
{3} Staff
{4}';
	$l['profilebuddies_pm_subject']='قمت باضافتك الي قائمة الاصدقاء';
	$l['profilebuddies_pm_message']='هلا {1},

قمت باضافتك الي قائمة اصدقائي اضغط [url={2}]هنا[/url] لمشاهدة ملفي الشخصي.

مع اطيب التحيات,
{3}';
	foreach($l as $key=>$val)
	{
		if(!$lang->$key)
		{
			$lang->$key=$val;
		}
	}
}

function profilebuddies()
{
	global $mybb,$lang,$db,$theme,$memprofile,$buddylist;
	profilebuddies_lang();
	if(!empty($memprofile['buddylist']))
	{
		$options=array
		(
			'order_by'=>$mybb->settings['profilebuddies_order_by'],
			'order_dir'=>$mybb->settings['profilebuddies_order_dir']
		);
		$buddies_full=explode(',',$memprofile['buddylist']);
		$buddies_count=count($buddies_full);
		if($mybb->settings['profilebuddies_limit_overwrite']==0)
		{
			$options['limit']=$mybb->settings['profilebuddies_limit'];
		}
		elseif(intval($mybb->input['buddies'])==1)
		{
			$options['limit']=$buddies_count;
		}
		else
		{
			$options['limit']=$mybb->settings['profilebuddies_limit'];
			if($buddies_count>$mybb->settings['profilebuddies_limit'])
			{
				$showall=$lang->sprintf($lang->profilebuddies_title_all,$buddies_count);
			}
		}
		$query=$db->simple_select('users','uid,username,avatar,avatardimensions,usergroup,displaygroup','uid IN('.$memprofile['buddylist'].')',$options);
		list($max_width,$max_height)=explode('x',my_strtolower($mybb->settings['postmaxavatarsize']));
		require_once MYBB_ROOT.'inc/functions_image.php';
		while($buddy=$db->fetch_array($query))
		{
			$avatar_default='';
			if(!($buddy['avatar']))
			{
				$buddy['avatar']=$theme['imgdir'].'/default_avatar.gif';
				$buddy['avatardimensions']='44|44';
				$avatar_default='style="border:1px solid #cccccc;" ';
			}
			$buddy['avatar']=htmlspecialchars_uni($buddy['avatar']);
			$avatar_dimensions=explode('|',$buddy['avatardimensions']);
			if($avatar_dimensions[0]&&$avatar_dimensions[1])
			{
				if($avatar_dimensions[0]>$max_width||$avatar_dimensions[1]>$max_height)
				{
					$scaled_dimensions=scale_image($avatar_dimensions[0],$avatar_dimensions[1],$max_width,$max_height);
					$avatar_width_height='width="'.$scaled_dimensions['width'].'" height="'.$scaled_dimensions['height'].'"';
				}
				else
				{
					$avatar_width_height='width="'.$avatar_dimensions[0].'" height="'.$avatar_dimensions[1].'"';
				}
				$buddy_avatar='<a href="'.get_profile_link($buddy['uid']).'"><img src="'.$buddy['avatar'].'" alt="'.htmlspecialchars_uni($buddy['username']).'" '.$avatar_width_height.' '.$avatar_default.'/></a>';
			}
			$buddy_name=format_name($buddy['username'],$buddy['usergroup'],$buddy['displaygroup']);
			$buddy_link='<span>'.build_profile_link($buddy_name,$buddy['uid']).'</span>';
			$buddies.='<li style="display:inline-block;padding:10px;text-align:center;">'.$buddy_avatar.'<br />'.$buddy_link.'</li>';
		}
		$buddies='<ul style="margin:0;padding:0;">'.$buddies.'</ul>';
	}
	else
	{
		$buddies=$lang->sprintf($lang->profilebuddies_no_buddies,htmlspecialchars_uni($memprofile['username']));
	}
	if($mybb->user['uid']!=0&&$mybb->settings['profilebuddies_quicklinks']==1&&$mybb->user['uid']!=$memprofile['uid'])
	{
		$user_buddys=explode(',',$mybb->user['buddylist']);
		if(in_array($memprofile['uid'],$user_buddys))
		{
			$addremove='<tr><td class="trow2"><a href="'.$mybb->settings['bburl'].'/usercp.php?action=do_editlists&amp;delete='.$memprofile['uid'].'&amp;my_post_key='.$mybb->post_code.'">'.$lang->sprintf($lang->profilebuddies_remove_buddy,htmlspecialchars_uni($memprofile['username'])).'</a></td></tr>';
		}
		else
		{
			$addremove='<tr><td class="trow2"><a href="'.$mybb->settings['bburl'].'/usercp.php?action=do_editlists&amp;add_username='.htmlspecialchars_uni($memprofile['username']).'&amp;my_post_key='.$mybb->post_code.'">'.$lang->sprintf($lang->profilebuddies_add_buddy,htmlspecialchars_uni($memprofile['username'])).'</a></td></tr>';
		}
	}
	$title='<strong>'.$lang->sprintf($lang->profilebuddies_title,htmlspecialchars_uni($memprofile['username'])).'</strong>';
	if($showall)
	{
		$link=get_profile_link($memprofile['uid']);
		if(my_strpos($link,'?'))
		{
			$link=$link.'&buddies=1';
		}
		else
		{
			$link=$link.'?buddies=1';
		}
		$title='<div class="float_right"><a href="'.$link.'">'.$showall.'</a></div><div>'.$title.'</div>';
	}
	$buddylist='<table border="0" cellspacing="'.$theme['borderwidth'].'" cellpadding="'.$theme['tablespace'].'" class="tborder"><tbody><tr><td class="thead">'.$title.'</td></tr><tr><td class="trow1 smalltext">'.$buddies.'</td></tr>'.$addremove.'</tbody></table>';
}

function profilebuddies_message()
{
	global $mybb,$lang,$message,$error_message,$db,$users;
	profilebuddies_lang();
	if($mybb->settings['profilebuddies_email']==1||$mybb->settings['profilebuddies_pm']==1)
	{
		if($message==$lang->users_added_to_buddy_list&&empty($error_message))
		{
			require_once MYBB_ROOT.'inc/datahandlers/pm.php';
			foreach($users as $user)
			{
				$query=$db->simple_select('users','uid,email','username="'.$user.'"');
				$result=$db->fetch_array($query);
				if($mybb->settings['profilebuddies_email']==1)
				{
					$subject=$lang->sprintf($lang->profilebuddies_email_subject,$mybb->settings['bbname']);
					$body=$lang->sprintf($lang->profilebuddies_email_message,$user,$mybb->user['username'],$mybb->settings['bbname'],$mybb->settings['bburl'],get_profile_link($mybb->user['uid']));
					my_mail($result['email'],$subject,$body);
				}
				if($mybb->settings['profilebuddies_pm']==1)
				{
					$subject=$lang->sprintf($lang->profilebuddies_pm_subject);
					$body=$lang->sprintf($lang->profilebuddies_pm_message,$user,$mybb->settings['bburl'].'/'.htmlspecialchars_decode(get_profile_link($mybb->user['uid'])),$mybb->user['username']);
					$pmhandler=new PMDataHandler();
					$pm=array(
						'subject'=>$subject,
						'message'=>$body,
						'toid'=>array($result['uid']),
						'options'=>array
						(
							'savecopy'=>0
						),
						'fromid'=>$mybb->user['uid']
					);
					$pmhandler->admin_override=true;
					$pmhandler->set_data($pm);
					$pmhandler->validate_pm();
					$pmhandler->insert_pm();
				}
			}
		}
	}
}

?>